import matplotlib
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec
import numpy as np

color_list=['tab:green','tab:orange','tab:blue']

def collision(x,y):
  if x>=2 and x<=7 and y>=3 and y<=4:
    return True
  elif x>=3 and x<=6 and y>=7 and y<=8:
    return True
  else:
    return False

def draw_trajectory():
  fig,ax=plt.subplots()
  ax.axis('scaled')
  ax.set_xticks(np.linspace(0,8,9))
  ax.set_yticks(np.linspace(0,12,13))
  ax.axis([0,9,0,13])
  ax.grid(linestyle='-',color='black')
  #obstacle1=plt.Rectangle((2.05,3.05),4.9,0.9,linewidth=2,color='tab:orange',facecolor='none')
  #obstacle2=plt.Rectangle((3.05,7.05),2.9,0.9,linewidth=2,color='tab:orange',facecolor='none')
  #obstacle3=plt.Rectangle((3.05,7.05),2.9,0.9,linewidth=2,color='tab:orange',facecolor='none')
  #obstacle4=plt.Rectangle((4.05,8.05),1.9,0.9,linewidth=2,color='tab:orange',facecolor='none')

  #ax.add_patch(obstacle1)
  #ax.add_patch(obstacle2)
  #ax.add_patch(obstacle3)
  #ax.add_patch(obstacle4)

  obstacle1=plt.Rectangle((2,3),1,1,linewidth=2,edgecolor='black',facecolor='none')
  obstacle2=plt.Rectangle((3,3),1,1,linewidth=2,edgecolor='black',facecolor='none')
  obstacle3=plt.Rectangle((4,3),1,1,linewidth=2,edgecolor='black',facecolor='none')
  obstacle4=plt.Rectangle((5,3),1,1,linewidth=2,edgecolor='black',facecolor='none')
  obstacle5=plt.Rectangle((6,3),1,1,linewidth=2,edgecolor='black',facecolor='none')
  obstacle6=plt.Rectangle((3,7),1,1,linewidth=2,edgecolor='black',facecolor='none')
  obstacle7=plt.Rectangle((4,7),1,1,linewidth=2,edgecolor='black',facecolor='none')
  obstacle8=plt.Rectangle((5,7),1,1,linewidth=2,edgecolor='black',facecolor='none')
  obstacle9=plt.Rectangle((3,7),1,1,linewidth=2,edgecolor='black',facecolor='none')
  obstacle10=plt.Rectangle((3,12),1,1,linewidth=2,edgecolor='black',facecolor='none')
  obstacle11=plt.Rectangle((4,8),1,1,linewidth=2,edgecolor='black',facecolor='none')
  obstacle12=plt.Rectangle((4,12),1,1,linewidth=2,edgecolor='black',facecolor='none')
  obstacle13=plt.Rectangle((8,2),1,1,linewidth=2,edgecolor='black',facecolor='none')

  ax.add_patch(obstacle1)
  ax.add_patch(obstacle2)
  ax.add_patch(obstacle3)
  ax.add_patch(obstacle4)
  ax.add_patch(obstacle5)
  ax.add_patch(obstacle6)
  ax.add_patch(obstacle7)
  ax.add_patch(obstacle8)
  ax.add_patch(obstacle9)
  ax.add_patch(obstacle10)
  ax.add_patch(obstacle11)
  ax.add_patch(obstacle12)
  ax.add_patch(obstacle13)

  ax.scatter(2.5,3.5,s=160,c="r",marker="x")
  ax.scatter(3.5,3.5,s=160,c="r",marker="x")
  ax.scatter(4.5,3.5,s=160,c="r",marker="x")
  ax.scatter(5.5,3.5,s=160,c="r",marker="x")
  ax.scatter(6.5,3.5,s=160,c="r",marker="x")
  ax.scatter(3.5,7.5,s=160,c="r",marker="x")
  ax.scatter(4.5,7.5,s=160,c="r",marker="x")
  ax.scatter(5.5,7.5,s=160,c="r",marker="x")
  ax.scatter(8.5,2.5,s=160,c="r",marker="x")
  ax.scatter(4.5,8.5,s=160,c="r",marker="x")
  ax.scatter(3.5,12.5,s=160,c="r",marker="x")
  ax.scatter(4.5,12.5,s=160,c="r",marker="x")
  ax.text(1.35,1.35,'$s_0$',fontsize=10)
  ax.text(7.35,12.35,'$s_G$',fontsize=10)
  ax.text(7.35,1.35,'$s_0^{\prime}$',fontsize=10)
  ax.text(1.35,12.35,'$s_G^{\prime}$',fontsize=10)
  for axi in (ax.xaxis, ax.yaxis):
      for tic in axi.get_major_ticks():
          tic.tick1On = tic.tick2On = False
          tic.label1On = tic.label2On = False

  collision_times=0.0
  
  index=[1,5,43]
  m=0

  for i in index:
    trajectory11=np.loadtxt("learned_agent1_trajectory_file"+str(i)+".txt",dtype=float)
    length1=(1.0*len(trajectory11))/2.0
    trajectory1=[]
    for j in range(int(length1)):
      trajectory1.append([trajectory11[2*j],trajectory11[2*j+1]])
    if i==5:
      i=47

    trajectory22=np.loadtxt("learned_agent2_trajectory_file"+str(i)+".txt",dtype=float)
    length2=(1.0*len(trajectory22))/2.0
    trajectory2=[]
    for j in range(int(length2)):
      trajectory2.append([trajectory22[2*j],trajectory22[2*j+1]])
    x1=[]
    y1=[]
    x2=[]
    y2=[]
    steps1=len(trajectory1)
    for j in range(steps1):
      if collision(trajectory1[j][0],trajectory1[j][1]):
        collision_times=collision_times+1.0
        break
      else:
        x1.append(trajectory1[j][0])
        y1.append(trajectory1[j][1])

    steps2=len(trajectory2)
    for j in range(steps2):
      if collision(trajectory2[j][0],trajectory2[j][1]):
        collision_times=collision_times+1.0
        break
      else:
        x2.append(trajectory2[j][0])
        y2.append(trajectory2[j][1])

    plt.plot(x1,y1,'r',linewidth=2)
    plt.plot(x2,y2,'b',linewidth=2)
    m=m+1
    
    

  #plt.savefig('trajectories.pdf') 
  print('constraint violation rate is: ', collision_times/100)
  print('success rate is: ', 1-collision_times/100)
  plt.show()


draw_trajectory()



















